@extends('layouts.main')

@section('styles')
@endsection

@section('content')

<!-- Start main-content -->
<div class="main-content">
  <!-- Section: inner-header -->
  <section class="inner-header divider parallax layer-overlay overlay-dark-5" data-bg-img="{{ asset('assets/images/bg/bg6.jpg')}}" style="background-image: url(&quot;images/bg/bg6.jpg&quot;); background-position: 50% 58px;">
    <div class="container pt-30 pb-40">
      <!-- Section Content -->
      <div class="section-content">
        <div class="row">
          <div class="col-md-12">
            <h2 class="title text-white text-center">Frequently Asked Questions</h2>

          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Section: About -->
<section class="position-inherit">
    <div class="container">
      <div class="row">
        <div class="col-md-3 scrolltofixed-container">
          <div class="list-group scrolltofixed-sidebar z-index-0" style="z-index: auto; position: static; top: auto;">
            <a href="#section-one" class="list-group-item smooth-scroll-to-target">Is The Educators Academy approved by ministry to grant credits?</a>

            <a href="#section-two" class="list-group-item smooth-scroll-to-target">Who can get credits at The Educators Academy?</a>

            <a href="#section-three" class="list-group-item smooth-scroll-to-target">What credits are offered at The Educators Academy?</a>

            <a href="#section-four" class="list-group-item smooth-scroll-to-target">How often students have to attend classes?</a>

            <a href="#section-five" class="list-group-item smooth-scroll-to-target">What is the cost to get credits?</a>

            <a href="#section-six" class="list-group-item smooth-scroll-to-target">What are the payment options?</a>

            <a href="#section-seven" class="list-group-item smooth-scroll-to-target">Do students have to buy their own textbooks?</a>

            <a href="#section-eight" class="list-group-item smooth-scroll-to-target">What is the class size at The Educators Academy?</a>

            <a href="#section-nine" class="list-group-item smooth-scroll-to-target">When do students get their report cards?</a>

          </div><div style="display: none; width: 262.5px; height: 290px; float: none;"></div>

        </div>
        <div class="col-md-9">
          <div id="section-one" class="mb-50">
            <h3 class="text-red">Is The Educators Academy approved by ministry to grant credits?</h3>
            <hr>
            <p class="mb-20">Yes. The Educators Academy has been issued a BSID number by Ministry of Education and is listed as a private school on the Ministry Website. The school has authority to grant credits towards Ontario Secondary School Diploma (OSSD). The credits you get at our School are good to get admission in other Schools, Colleges and Universities in Ontario as well as other provinces of Canada. They are also good to get admission in overseas educational institutions based on their eligibility requirements. You can check our school's authorization by Ministry of education by using the following link. <a href="http://www.edu.gov.on.ca/eng/general/elemsec/privsch/">http://www.edu.gov.on.ca/eng/general/elemsec/privsch/</a>
</p>
          </div>
          <div id="section-two" class="mb-50">
            <h3 class="text-red">Who can get credits at The Educators Academy?</h3>
            <hr>
            <p class="mb-20">High School students, mature students and newcomers to Canada can get credits if they are eligible. For eligibility criteria please contact the office.</p>
          </div>
          <div id="section-three" class="mb-50">
            <h3 class="text-red">What credits are offered at The Educators Academy?</h3>
            <hr>
            <p class="mb-20">We offer High School credits from grade 9 to 12 in various subjects such as Math, English, Biology, Chemistry, Computers, and Business Studies etc. For full list of course please click the link.</p>
          </div>
          <div id="section-four" class="mb-50">
            <h3 class="text-red">How often students have to attend classes?</h3>
            <hr>
            <p class="mb-20">Students have greater flexibility to attend classes. Students are expected to attend at least 110 hours as per criteria of Ministry. Each class has duration of 75 minutes and can attend either in morning, afternoon or evening sessions. School is open from 9 AM to 7 PM Monday to Friday for part time students.</p>
          </div>
          <div id="section-five" class="mb-50">
            <h3 class="text-red">What is the cost to get credits?</h3>
            <hr>
            <p class="mb-20">The Educators Academy offers competitive price in Brampton to get high School credits. There is no registration cost. Part time students pay only $475 per credit. For full details and discount on multiple credits check our admissions page:</p>
          </div>


          <div id="section-six" class="mb-50">
            <h3 class="text-red">What are the payment options?</h3>
            <hr>
            <p class="mb-20">There are no registration charges. After registration, students have to pay full amount once either by Visa, Master card, Cheque, Cash or e-Transfer.</p>
          </div>

          <div id="section-seven" class="mb-50">
            <h3 class="text-red">Do students have to buy their own textbooks?</h3>
            <hr>
            <p class="mb-20">Students can get their own textbooks. The Educators Academy provides free books and Pdf books to the students so they can prepare themselves.</p>
          </div>

          <div id="section-eight" class="mb-50">
            <h3 class="text-red">What is the class size at The Educators Academy?</h3>
            <hr>
            <p class="mb-20">Our classes are small as 4-5 students in the class.</p>
          </div>

          <div id="section-nine" class="mb-50">
            <h3 class="text-red">When do students get their report cards?</h3>
            <hr>
            <p class="mb-20">Report cards are issued 1 week after final exams. Student must clear their account balance, return the textbook and provide any missing document required by the office in order to get the report card.</p>
          </div>







        </div>
      </div>
    </div>
  </section>

</div>
<!-- end main-content -->



@endsection

@section('scripts')

          <script>
            /* scrollto fixed script */
            $(document).ready(function(e) {
              if($(window).width() >= 768){
                $('.scrolltofixed-sidebar').scrollToFixed({
                    marginTop: $('.header .header-nav').outerHeight(true) + 100,
                    limit: function() {
                        var limit = $('.footer').offset().top - $(this).outerHeight(true) - 10;
                        return limit;
                    }
                });
              }
            });
          </script>
@endsection
